#include "game.h"

#define PLAYER_FULLSPEED (0x1C0)
#define PLAYER_TURNSPEED (PLAYER_FULLSPEED*0.7)

void Player_ShootBullet(void)
{
	//kramPlay(samples[SAMPLE_LAZERSHOT1],1,0);
	if(active_playerbullets==PLAYER_BULLETS) return;
	sBullet* b = &playerbullets[active_playerbullets++];

	b->xfixed = player.x-(6<<8);
	b->yfixed = player.y-(2<<8);
	b->xinc = 0;
	b->yinc = -0x300;

	if(active_playerbullets==PLAYER_BULLETS) return;
	b = &playerbullets[active_playerbullets++];

	b->xfixed = player.x+(6<<8);
	b->yfixed = player.y-(2<<8);
	b->xinc = 0;
	b->yinc = -0x300;
}

void Player_ShootSpread(void)
{
	//kramPlay(samples[SAMPLE_LAZERSHOT1],1,0);
	if(active_playerbullets==PLAYER_BULLETS) return;
	sBullet* b = &playerbullets[active_playerbullets++];

	b->xfixed = player.x;
	b->yfixed = player.y-(10<<8);
	b->xinc = 0;
	b->yinc = -0x260;

	if(active_playerbullets==PLAYER_BULLETS) return;
	b = &playerbullets[active_playerbullets++];

	b->xfixed = player.x+(6<<8);
	b->yfixed = player.y-(2<<8);
	b->xinc = 0x70;
	b->yinc = -0x220;

	if(active_playerbullets==PLAYER_BULLETS) return;
	b = &playerbullets[active_playerbullets++];

	b->xfixed = player.x-(6<<8);
	b->yfixed = player.y-(2<<8);
	b->xinc = -0x70;
	b->yinc = -0x220;
}

void PlayerUpdate(void)
{
	if(KEY(KEY_UP)||KEY(KEY_DOWN))
	{
		if(KEY(KEY_UP))
		{
			if(KEY(KEY_LEFT)) { player.y-=PLAYER_TURNSPEED; player.x-=PLAYER_TURNSPEED; }
			else if(KEY(KEY_RIGHT)) { player.y-=PLAYER_TURNSPEED; player.x+=PLAYER_TURNSPEED; }
			else player.y-=PLAYER_FULLSPEED;
		}
		if(KEY(KEY_DOWN))
		{
			if(KEY(KEY_LEFT)) { player.y+=PLAYER_TURNSPEED; player.x-=PLAYER_TURNSPEED; }
			else if(KEY(KEY_RIGHT)) { player.y+=PLAYER_TURNSPEED; player.x+=PLAYER_TURNSPEED; }
			else player.y+=PLAYER_FULLSPEED;
		}
	}
	else if(KEY(KEY_RIGHT)) player.x+=PLAYER_FULLSPEED;
	else if(KEY(KEY_LEFT)) player.x-=PLAYER_FULLSPEED;

	if(player.x<0) player.x = 0;
	if(player.y<0) player.y = 0;
	if(player.x>239<<8) player.x = 239<<8;
	if(player.y>159<<8) player.y = 159<<8;

	player.m.x = player.x>>8;
	player.m.y = player.y>>8;

	DrawModel(&player.m);

	if(player.shootcooldown) player.shootcooldown--;

	if(KEY(KEY_A)){
		if(!player.shootcooldown){
			player.shootcooldown = 6;
			Player_ShootBullet();
		}
	}
	if(KEY(KEY_B)){
		if(!player.shootcooldown){
			player.shootcooldown = 9;
			Player_ShootSpread();
		}
	}
}







